let ts_rtv = {
    "rqname": "ln_trvlrqs",
    "rqcn": "ln_rqcn",
    "rqttl": 10,
    "cjurl": null,
    "hturl": null,
    "lang": "",
    "recheck_interval": 30,
    "sttl": 30,
}
ts_rtv.refresh = function(){
    if (this.rqttl > 1){
        var requested = ts_localStorage.getLocalCache(this.rqname);
        if (requested) return;
    }
    jQuery.ajax({
        method: "POST",
        data: {
            "action": "ts_rtv_pro",
        },
        url: ajaxurl,
    });
    if (this.rqttl > 1) ts_localStorage.setLocalCache(this.rqname, "yes", this.rqttl);
}
ts_rtv.userView = function(d){

    if (typeof(d) !== typeof({}) || d === null) return;
    if ("id" in d === false) return;
    
    jQuery.ajax({
        method: "POST",
        data: d,
        url: ajaxurl,
    }).done(function(){
        ts_rtv.refresh();
    });

    var recallTimeout = (this.sttl - 1);
    if (recallTimeout < 1) recallTimeout = 1;
    recallTimeout = recallTimeout * 1000 * 60;

    ts_localStorage.removeLocalCache(this.rqcn);
    ts_localStorage.setLocalCache(this.rqcn, d.id, this.sttl * 60 * 1000);

    setTimeout(function(){
        var last_id = ts_localStorage.getLocalCache(ts_rtv.rqcn);
        if (last_id != d.id && last_id !== null) return;
        ts_rtv.userView(d);
    }, recallTimeout);
};
ts_rtv.updateHtml = function(){
    if ( ! this.cjurl) return;
    jQuery.get(this.cjurl + "?time=" + new Date().getTime()).done(function(e){
        if ("hash" in e == false) return;
        if ("data" in e == false) return;
        if (typeof(e.data) !== typeof([])) return;
        var currentHash = ts_rtv.getCurrentHash();
        if ( ! currentHash) return;
        if (currentHash != e.hash){
            ts_rtv.reloadHTML();
            ts_rtv.updateHash(e.hash);
            return;
        }
        for(var i of ts_rtv.getIDs()){
            if (i in e.data == false) continue;
            var vdata = e.data[i];
            if ("view" in vdata == false) continue;
            var el = jQuery(document).find(`.ts-rtv-count[data-id=${i}]`);
            if (el.length < 1) continue;
            el.html(`${vdata.view} ${ts_rtv.lang}`);
        }
    });
    setTimeout(() => {
        ts_rtv.updateHtml();
    }, ts_rtv.recheck_interval * 1000);
}
ts_rtv.reloadHTML = function(){
    if ( ! this.hturl) return;
    $( "#ts-rtv-pool" ).load( `${this.hturl}?time=${new Date().getTime()} .ts-rtv-cont` );
}
ts_rtv.getIDs = function(){
    var els = jQuery(document).find('.ts-rtv-count');
    var ids = [];
    for(var i of els){
        var id = i.getAttribute('data-id');
        if (isNaN(id)) continue;
        ids.push(parseInt(id));
    }
    return ids;
}
ts_rtv.getCurrentHash = function(){
    var hash = jQuery(document).find('#ts-rtv-pool').attr('data-hash');
    if ( ! hash) return null;
    if (typeof(hash) !== typeof("")) return null;
    return hash;
}
ts_rtv.updateHash = function(new_hash){
    if ( ! new_hash) return null;
    if (typeof(new_hash) !== typeof("")) return null;
    new_hash = decodeURIComponent(new_hash);
    jQuery(document).find('#ts-rtv-pool').attr('data-hash', new_hash);
}