<?php
add_filter( 'rwmb_meta_boxes', 'your_prefix_register_meta_boxes' );
function your_prefix_register_meta_boxes( $meta_boxes )
{
	$prefix = 'ero_';
	$meta_boxes[] = array(
		'id' => 'autogenerateimgcat',
		'title' => __( 'Automatic', 'meta-box' ),
	        'pages' => array( 'series' ),
	        'context' => 'normal',
		'priority' => 'low',
		'autosave' => false,
		'fields' => array(
			array(
				
				'id'   => "{$prefix}autogenerateimgcat",
				'desc'  => __( 'Auto Create Featured Image and Category', 'meta-box' ),
				'type' => 'checkbox',
				'std' => 1,
			),
			array(
				'name'  => __( 'Auto Generate Image URL', 'meta-box' ),
				'id'    => "{$prefix}image",
				'type'  => 'text',
			),
		)
	);
	$prefix = 'ero_';
	$meta_boxes[] = array(
		'id' => 'series_generate',
		'title' => __( 'Generate Data (from novelupdates.com)', 'meta-box' ),
	        'pages' => array( 'series' ),
	        'context' => 'normal',
		'priority' => 'low',
		'autosave' => false,
		'fields' => array(
			array(
				"name" => "URL",
				'id'   => "{$prefix}series_generate",
				'desc'  => __( 'Generate Series Info From NovelUpdates', 'meta-box' ),
				'type' => 'text',			
			),
			array(
				'name'  => __( 'Language', 'meta-box' ),
				'id'    => "{$prefix}generate_desc_lang",
				'type'  => 'select',
				'desc' => 'Auto translate Synopsis. if translate version not available, english version will be used',
				'options'  => array(
					'default' => __( 'EN', 'meta-box' ),
					'id' => __( 'ID', 'meta-box' ),
					'ms' => __( 'MY', 'meta-box' ),
					'ru' => __( 'RU', 'meta-box' ),
					'es' => __( 'ES', 'meta-box' ),
					'in' => __( 'IN', 'meta-box' ),
				),
			),
			array(
				'type'       => 'button',
				'name'       => 'Generate Data',
				// Button text.
				'std'        => 'Generate',
				// Custom HTML attributes.
				'attributes' => array(
					'data-section' => 'novelupdates',
					'class'        => 'sg-generate',
				),
			),			
		)
	);
	$prefix = 'ero_';
		$meta_boxes[] = array(
		'id' => 'series',
		'title' => __( 'Series Info', 'meta-box' ),
	        'pages' => array( 'series' ),
		'context' => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields' => array(
			array(
                'name'  => __( 'Big Cover', 'meta-box' ),
                'id'    => "{$prefix}cover",
                'type'  => 'image_advanced',
				'max_file_uploads' => '1'
            ),
			array(
				'name'     => __( 'Hot Series?', 'meta-box' ),
				'id'       => "{$prefix}hot",
				'type'     => 'select',
				'options'  => array(
					'1' => __( 'Yes', 'meta-box' ),
					'0' => __( 'No', 'meta-box' ),
				),
				'multiple'    => false,
				'std'         => '0',
			),
			array(
				'name'     => __( 'Project?', 'meta-box' ),
				'id'       => "{$prefix}project",
				'type'     => 'select',
				'options'  => array(
					'0' => __( 'No', 'meta-box' ),
					'1' => __( 'Yes', 'meta-box' ),
				),
				'multiple'    => false,
				'std'         => '0',
			),
			array(
				'name'     => __( 'Mature Content?', 'meta-box' ),
				'id'       => "{$prefix}mature",
				'type'     => 'select',
				'options'  => array(
					'No' => __( 'No', 'meta-box' ),
					'Yes' => __( 'Yes', 'meta-box' ),
				),
				'multiple'    => false,
				'std'         => 'No',
			),
			array(
				'name'     => __( 'Status', 'meta-box' ),
				'id'       => "{$prefix}status",
				'type'     => 'select',
				'options'  => array(
					'Ongoing' => __( 'Ongoing', 'meta-box' ),
					'Hiatus' => __( 'Hiatus', 'meta-box' ),
					'Completed' => __( 'Completed', 'meta-box' ),
				),
				'multiple'    => false,
				'std'         => 'Ongoing',
			),
			array(
				'name' => __( 'Alternative', 'meta-box' ),
				'id'   => "{$prefix}alt",
				'type' => 'text',
			),
			array(
				'name'  => __( 'Native Language', 'meta-box' ),
				'id'    => "{$prefix}lang",
				'type'  => 'text',
			),
			array(
				'name'  => __( 'Release Year', 'meta-box' ),
				'id'    => "{$prefix}date",
				'type'  => 'text',
			),
			array(
				'name'  => __( 'Score', 'meta-box' ),
				'id'    => "{$prefix}score",
				'type'  => 'text',
			),
		)
	);
	$meta_boxes[] = array(
		'id' => 'galleryarea',
		'title' => __( 'Gallery', 'meta-box' ),
	        'pages' => array( 'series' ),
	        'context' => 'normal',
		'fields' => array(
			array(
				'name' => __( 'Upload', 'meta-box' ),
				'id'   => "{$prefix}gallery",
				'type' => 'image_advanced',
				'force_delete' => false,
				'image_size' => 'thumbnail',
			),
		)
	);
		$meta_boxes[] = array(
		'id' => 'chapter',
		'title' => __( 'Chapter', 'meta-box' ),
	        'pages' => array( 'post' ),
		'context' => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields' => array(
			array(
				'name' => __( 'Volume', 'meta-box' ),
				'id'   => "{$prefix}volume",
				'type' => 'text',
			),
			array(
				'name' => __( 'Chapter', 'meta-box' ),
				'id'   => "{$prefix}chapter",
				'type' => 'text',
				'required' => 1,
			),
			array(
				'name'  => __( 'Chapter Title', 'meta-box' ),
				'id'    => "{$prefix}title",
				'type'  => 'text',
			),
			array(
				'name'    => __( 'Series', 'meta-box' ),
				'id'      => "{$prefix}series",
				'type'    => 'post',
				'required' => 1,

				// Post type
				'post_type' => 'series',
				// Field type, either 'select' or 'select_advanced' (default)
				'field_type' => 'select_advanced',
				// Query arguments (optional). No settings means get all published posts
				'query_args' => array(
					'post_status'    => array('publish','draft'),
					'posts_per_page' => - 1,
				)
			),
		)
	);
	return $meta_boxes;
}